define(['app', 'angular'], function (app, angular) {
	'use strict';

	app.config(function ($provide) {
		$provide.decorator("uiMaskDirective", function($delegate, $timeout){
			var directive = $delegate[0];
			
			var compile = directive.compile;
			directive.compile = function(){
				var link = compile.apply(this, arguments);
				return function(scope, iElement, iAttrs, controller){
					link.apply(this, arguments);

					var useViewValue;

			    	var uiMaskDecorationBlurHandler = function() {
	    				if(iElement.attr("placeholder") === iElement.val()) {
	    					iElement.val('');
	    				} else if(useViewValue) {
	    					controller.$setViewValue(iElement.val());
	    				}
	    				scope.$apply();
			    	};

			    	iAttrs.$observe('uiMaskUseViewValue', function (useVVal) {
			        	useViewValue = useVVal == 'true';
			    	});

			    	iAttrs.$observe('uiMask', function () {
			    		var blurList = angular.element._data(iElement[0], "events").blur;
			    		for(var i = blurList.length - 1; i >= 0; i--) {
			    			var functionName = blurList[i].handler.toString();
							functionName = functionName.substr('function '.length);
							functionName = functionName.substr(0, functionName.indexOf('('));
			    			if(functionName === "blurHandler") {
				    			iElement.unbind("blur", blurList[i].handler);
				    			iElement.bind("blur", uiMaskDecorationBlurHandler);
				    			break;
			    			}
			    		}
			    	});

					controller.$parsers.push(function(fromViewValue) {
						return useViewValue ? (controller.$viewValue || undefined) : fromViewValue;
					});

					scope.$on('$destroy', function() {
						iElement.unbind("blur". uiMaskDecorationBlurHandler);
					});
					
					if(!scope.ngModel) {
						$timeout(function(){iElement.val('');});
					}
				}

			};
			return $delegate;
		});
	});
});